#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "mdgrape3.h"


double m2_grav(double x){
	if(x == 0){
		return 0;
	}
	return -pow(x, -1.5);
}


double m2_grav_(double *x)
{
  return m2_grav(*x);
}


double m2_grav__(double *x)
{
  return m2_grav(*x);
}


double m2_gravpot(double x){
	if(x == 0){
		return 0;
	}
	return pow(x, -0.5);
}


double m2_gravpot_(double *x)
{
  return m2_gravpot(*x);
}


double m2_gravpot__(double *x)
{
  return m2_gravpot(*x);
}


double m2_lj(double x){
	if(x < 0.25 || 64 < x){
		return 0;
	}
	return -(2 * pow(x, -7) - pow(x, -4));
}


double m2_lj_(double *x)
{
  return m2_lj(*x);
}


double m2_lj__(double *x)
{
  return m2_lj(*x);
}


double m2_ljpot(double x){
	if(x < 0.25 || 64 < x){
		return 0;
	}
	return pow(x, -6) - pow(x, -3);
}


double m2_ljpot_(double *x)
{
  return m2_ljpot(*x);
}


double m2_ljpot__(double *x)
{
  return m2_ljpot(*x);
}


double m2_real(double x){
	if(x < 1e-17 || 100 < x){
		return 0;
	}
	return -(M_2_SQRTPI * exp(-x) / x + erfc(sqrt(x)) * pow(x, -1.5));
}


double m2_real_(double *x)
{
  return m2_real(*x);
}


double m2_real__(double *x)
{
  return m2_real(*x);
}


double m2_realpot(double x){
	if(x < 1e-17 || 100 < x){
		return 0;
	}
	return erfc(sqrt(x)) * pow(x, -0.5);
}


double m2_realpot_(double *x)
{
  return m2_realpot(*x);
}


double m2_realpot__(double *x)
{
  return m2_realpot(*x);
}


int m2_allocate_unit_(char *fname, int *mode, double *xmin, double *xmax, 
		      int *dum, int nchar)
{
  return m3_allocate_unit_(fname,mode,xmin,xmax,dum,nchar);
}


int m2_allocate_unit__(char *fname, int *mode, double *xmin, double *xmax, 
		       int *dum, int nchar)
{
  return m3_allocate_unit_(fname,mode,xmin,xmax,dum,nchar);
}


int m2_allocate_periodic_unit_(char *fname, int *mode, double *size, 
				int *dum, int nchar)
{
  return m3_allocate_periodic_unit_(fname,mode,size,dum,nchar);
}


int m2_allocate_periodic_unit__(char *fname, int *mode, double *size, 
				int *dum, int nchar)
{
  return m3_allocate_periodic_unit_(fname,mode,size,dum,nchar);
}


void m2_free_unit_(int *unit_index)
{
  m3_free_unit_(unit_index);
}


void m2_free_unit__(int *unit_index)
{
  m3_free_unit_(unit_index);
}


void m2_set_positions_(int *unit_index, double (*pos)[3], int *n)
{
  m3_set_positions_(unit_index,pos,n);
}


void m2_set_positions__(int *unit_index, double (*pos)[3], int *n)
{
  m3_set_positions_(unit_index,pos,n);
}


void m2_set_types_(int *unit_index, int *atype, int *n)
{
  m3_set_types_(unit_index,atype,n);
}


void m2_set_types__(int *unit_index, int *atype, int *n)
{
  m3_set_types_(unit_index,atype,n);
}


void m2_set_charges_(int *unit_index, double *q, int *n)
{
  m3_set_charges_(unit_index,q,n);
}


void m2_set_charges__(int *unit_index, double *q, int *n)
{
  m3_set_charges_(unit_index,q,n);
}


void m2_set_softening_(int *unit_index, double *e)
{
  m3_set_softening_(unit_index,e);
}


void m2_set_softening__(int *unit_index, double *e)
{
  m3_set_softening_(unit_index,e);
}


void m2_set_softenings_(int *unit_index, double *softeningj, int *nj)
{
  m3_set_softenings_(unit_index,softeningj,nj);
}


void m2_set_softenings__(int *unit_index, double *softeningj, int *nj)
{
  m3_set_softenings_(unit_index,softeningj,nj);
}


void m2_set_pipeline_softenings_(int *unit_index, double *softeningi, int *ni)
{
  m3_set_pipeline_softenings_(unit_index,softeningi,ni);
}


void m2_set_pipeline_softenings__(int *unit_index, double *softeningi, int *ni)
{
  m3_set_pipeline_softenings_(unit_index,softeningi,ni);
}


void m2_set_rscale_matrix_(int *unit_index, double *rscale, 
			    int *nati, int *natj)
{
  m3_set_rscale_matrix_(unit_index,rscale,nati,natj);
}


void m2_set_rscale_matrix__(int *unit_index, double *rscale, 
			    int *nati, int *natj)
{
  m3_set_rscale_matrix_(unit_index,rscale,nati,natj);
}


void m2_set_charge_matrix_(int *unit_index, double *gscale, 
			    int *nati, int *natj)
{
  m3_set_charge_matrix_(unit_index,gscale,nati,natj);
}


void m2_set_charge_matrix__(int *unit_index, double *gscale, 
			    int *nati, int *natj)
{
  m3_set_charge_matrix_(unit_index,gscale,nati,natj);
}


void m2_set_rscale_(int *unit_index, double *rscale_sq)
{
  m3_set_rscale_(unit_index,rscale_sq);
}


void m2_set_rscale__(int *unit_index, double *rscale_sq)
{
  m3_set_rscale_(unit_index,rscale_sq);
}


void m2_set_cells_(int *unit_index, int *base, int *size, int *ncell)
{
  m3_set_cells_(unit_index,base,size,ncell);
}


void m2_set_cells__(int *unit_index, int *base, int *size, int *ncell)
{
  m3_set_cells_(unit_index,base,size,ncell);
}


void m2_set_pipeline_types_(int *unit_index, int *atype, int *n)
{
  m3_set_pipeline_types_(unit_index,atype,n);
}


void m2_set_pipeline_types__(int *unit_index, int *atype, int *n)
{
  m3_set_pipeline_types_(unit_index,atype,n);
}


void m2_calculate_forces_(int *unit_index, double (*xi)[3], int *ni,
			   double (*force)[3])
{
  m3_calculate_forces_(unit_index,xi,ni,force);
}


void m2_calculate_forces__(int *unit_index, double (*xi)[3], int *ni,
			   double (*force)[3])
{
  m3_calculate_forces_(unit_index,xi,ni,force);
}


void m2_calculate_potentials_(int *unit_index, double (*xi)[3], int *ni,
			       double *eng)
{
  m3_calculate_potentials_(unit_index,xi,ni,eng);
}


void m2_calculate_potentials__(int *unit_index, double (*xi)[3], int *ni,
			       double *eng)
{
  m3_calculate_potentials_(unit_index,xi,ni,eng);
}


void m2_set_host_function_(void){
}


void m2_set_host_function__(void){
}



