//#define MEASURE_TIME

//#define NO_READLINE             /* for systems with no readline support */
//#define NO_ZLIB                 /* for systems with no zlib support     */

#define MR3_M2_COMPATIBILITY     
                                /* support for m2 compatibility 
				    currently MR3_ALLOW_SETTYPES_AFTER_SETPOSITIONS
				    and MR3_ALLOW_SETSOFTENINGS_AFTER_SETPOSITIONS
				    must be defined 
				*/
#define MR3_ALLOW_SETTYPES_AFTER_SETPOSITIONS
                                /* allow m3_set_types before 
                                   m3_set_positions */
#define MR3_ALLOW_SETSOFTENINGS_AFTER_SETPOSITIONS
                                /* allow m3_set_softenings before 
                                   m3_set_positions */
                                /* these two definitions shoud be defined or not 
                                   together */
#define USE_VIR_MODE
#define MR3_DAISY_CHAIN
#define MR3_CHIPMASK_ENV        
                                /* use chip mask environmental variable 
				*/
//#define MR3_MALLOC              
                                /* define this to use rapper for malloc()
                                   and free() */
#define COULOMB_VDW_FACTOR        /* multiply factor for coulomb_vdw */

#define REBUILD_RUN2CELL_FOR_PROTEIN
#define MR3_CHECKSUM              
                                  /* define this to check checksum */

#define MR3_MAX_J_PARTICLE_PER_CHIP 32767
//#define MR3_MAX_J_PARTICLE_PER_CHIP 32760
//#define MR3_MAX_J_PARTICLE_PER_CHIP 30000
//#define MR3_MAX_J_PARTICLE_PER_CHIP 10000
//#define MR3_MAX_J_PARTICLE_PER_CHIP  2000
//#define MR3_MAX_J_PARTICLE_PER_CHIP   100
//#define MR3_MAX_J_PARTICLE_PER_CHIP    62

#define SORT_NATEX2            /* sort pdb */

//#define MR3_CHECK_TEMPERATURE_BEFORE_CALC   
                               /* define this to enable temperature checking
                                  when calculate forces */

#define CHANGE_PIPE_MODE_PER_LOGICAL_PIPE 
#define MR3_NUM_TEMPERATURE         13

#ifdef WIN32
#include <windows.h>
#ifndef uint
#define uint unsigned int
#endif
#endif

#ifndef TYPEDEF_LONGLONG
#define TYPEDEF_LONGLONG 
# ifdef BIG_ENDIAN
typedef struct { unsigned int h,l; } longlong;
# else
typedef struct { unsigned int l,h; } longlong;
# endif
#endif

typedef struct {
  char fname[100];
  int  mode;
  int  ewald;
#if 1
  uint (*c)[4];
  uint *e;
#else
  uint c[1024][4];
  uint e[1024];
#endif
  uint fevmode;
  double xsize;
} md3table ;

struct m3_overlap_struct{
  int ni;
  int mode; /* 0:force, 1:potential */
  double (*fp)[3];
#ifdef USE_VIR_MODE
  int virialmode; /* bit 0 -- x image exist (1) or not (0)
                     bit 1 -- y image exist (1) or not (0)
                     bit 2 -- z image exist (1) or not (0) */
  double *fifactor;
  double (*xi)[3];
  //  int offset[3];
  int (*icell_index)[4];
#endif
  struct m3_overlap_struct *prev;
  struct m3_overlap_struct *next;
};

typedef struct{
  int virialmode;   /*  bit 0 - 0 : region for x axis is not divided
			        1 : region for x axis is divided
                        bit 1     : region for y axis
                       bit 2     : region for z axis
                        bit 3 - 0 : icell index for x axis is close to zero
                                1 : icell index for x axis is close to ldimx
                        bit 4     : icell index for y axis
                        bit 5     : icell index for z axis
			bit 6 - 0 : copy_result_from_buffer returns ni*nread forces
                                1 : copy_result_from_buffer returns just ni forces
				    and calc virial in copy_result_from_buffer
			bit 7 - 0 : virialmode in copy_result_from_buffer is
                                    virial->virialmode
                                1 : virialmode in copy_result_from_buffer is
                                    from icell_index[3]. This mode is used for
                                    cimode=2 (such as calc_ci_core2)
		    */
  double virial[3][3];
  double boxsize[3];
  double *fifactor;
  double fifactor2;
  double (*xi)[3];
  //  int offset[3];
  int (*icell_index)[4];
  int wpoint_boxsize;
  int wpoint_rscale;
  int wpoint_grscale;
} VIRIAL;

typedef struct{
  long base;
  long size;
} M3_CELL;

typedef struct m3_unit M3_UNIT;

struct m3_unit{
  char tablefname[100];
  int mode;
  double xmax;
  double rscale_sq;
  int nat;
  int nj;
#if defined(MR3_ALLOW_SETTYPES_AFTER_SETPOSITIONS) || defined(MR3_ALLOW_SETSOFTENINGS_AFTER_SETPOSITIONS)
  double (*rj)[3];
#endif
#if defined(MR3_M2_COMPATIBILITY) 
  double *qj;
  M3_CELL *cell;
#endif
  int *atypei;
  int *atypej;
  float *softeningi;
  float *softeningj;
  double *gscale;
  double *rscale;
  int ncell;
  //  int virialmode;
  int overlap_mode; /* 0:normal, 1:m3_overlap */
  int overlap_count;
  struct m3_overlap_struct *overlap_struct_first;
  struct m3_overlap_struct *overlap_struct_current;
  VIRIAL virial;
};

typedef struct{
  int n;
  int *numex2;
  int *natex2;
  int *natex2_offset;
  int *pdb2mol;
  int *pdb2image;
  int *pdb2sortpdb;
  int *mainatom;  /* number of atoms in a molecule if this atom is a main 
                     atom in a molecule.  if minus, this atom is not main
                     atom.  effective only for water molecules            */
  int *skipflag;  /* bit 0 : 1 ---- Coulomb can be skipped
                     bit 1 : 1 ---- vdW can be skipped                    */
  unsigned long long *modeflag; 
                  /* same as modeflag in set_pipe_mode_with_flag()        */
  int ni_run_max;
} EXLIST;

typedef struct{
  int *nexlist_pdb;
  int *jexlist_pdb;
  unsigned long long *flagexlist_pdb;
  int *nflagexlist_pdb;
  int *offsetexlist_pdb;
  int nrun_protein;
  int nrun;
  int nex_protein;
  int nex;
  int min_mol;
  int max_mol;
  int ni_run;
} EXLIST_PDB;

typedef struct{
  int wpoint;
  int nparticle;
  int *index;
  double (*op)[3];
  unsigned long long *atype;
  int interleave;
  int dummy;
  int jloop;
} WPOINT_PINDEX; 

typedef union {
  struct{
    unsigned char uc0: 8;
    unsigned char uc1: 8;
    unsigned char uc2: 8;
    unsigned char uc3: 8;
  } uc4;
  unsigned int ui;
} UIUC4;

#ifdef MR3_MALLOC
#define MR3_malloc_pointer(x,y) MR3_my_malloc2(x,y)
#define MR3_free_pointer(x,y)   MR3_my_free2((void **)(&(x)),y)
#else
#define MR3_malloc_pointer(x,y) malloc(x)
#define MR3_free_pointer(x,y)   free(x)
#endif

#define MAX_REGISTER_EXLIST 100

#define M3_DEFAULT_TBLNO 999

#define M3_FORCE     0
#define M3_POTENTIAL 1

#ifndef NULL_INT
#include <limits.h>
#define NULL_INT INT_MIN
#endif

#ifndef M2_FORCE
#define M2_FORCE     0
#define M2_POTENTIAL 1
#define M2_UNIT      M3_UNIT
#define M2_CELL      M3_CELL
#define m2_allocate_unit                 m3_allocate_unit
#define m2_allocate_periodic_unit        m3_allocate_periodic_unit
#define m2_free_unit                     m3_free_unit
#define m2_set_function                  m3_set_function
#define m2_set_positions                 m3_set_positions
#define m2_set_charges                   m3_set_charges
#define m2_set_rscale                    m3_set_rscale
#define m2_set_types                     m3_set_types
#define m2_set_rscale_matrix             m3_set_rscale_matrix
#define m2_set_charge_matrix             m3_set_charge_matrix
#define m2_set_pipeline_types            m3_set_pipeline_types
#define m2_calculate_forces              m3_calculate_forces
#define m2_calculate_potentials          m3_calculate_potentials
#define m2_set_cells                     m3_set_cells
#define m2_set_softening                 m3_set_softening
#define m2_start_force_calculation       m3_start_force_calculation
#define m2_start_potential_calculation   m3_start_potential_calculation
#define m2_wait_calculation              m3_wait_calculation
#endif

#if 0
#ifndef m2_grav
#define m2_grav      0
#define m2_gravpot   0
#define m2_real      0
#define m2_realpot   0
#endif
#endif


#define NUM_MD3_CHIPS_MAX   12

//#define MAX_MD3_NEIGHBOR    30
#define MAX_MD3_NEIGHBOR    40

#define NUM_MD3_VMPS        40
#define NUM_MD3_EXCLUDELIST 32
#define NUM_MD3_RCLIST      1024

#define MR3_FILL_CHARGE_GRID_ORDER 4
/* mr3.c */
void MR3_set_Xmax(double xmax);
void MR3_set_Wpoint(int wpoint);
int MR3_get_Wpoint(void);
int MR3_get_Wpoint_last(void);
int MR3_get_Overlapflag(void);
void MR3_reset_md3link(void);
int MR3_get_retry_count(void);
int MR3_print_retry_messages(char *func_name, int *retrycount, int flag);
int MR3_get_total_num_chips(void);
int mr3_get_total_num_chips_(void);
int mr3_get_total_num_chips__(void);
int MR3_get_max_j_particle_per_chip(void);
int mr3_get_max_j_particle_per_chip_(void);
int mr3_get_max_j_particle_per_chip__(void);
int MR3_get_chipmask(void);
int MR3_get_frequency(void);
void MR3_get_new2org(int **new2org);
int MR3_get_board_version_local(void);
void MR3_rscale_and_pack(int n, double (*x)[3], int *atype, longlong (*rj)[2]);
void MR3_rscale_and_pack_old(int n, double (*x)[3], int *atype, longlong (*rj)[2]);
void MR3_set_ri_with_wpoint_pindex(int ni_run, double x[], int *atype_image, double volume[3], int (*cell_diff)[3], int flag_virial);
void MR3_set_ri_with_wpoint_pindex_vec(int ni_run, double x[]);
void MR3_set_ri_with_wpoint_pindex_old(int ni_run, double x[]);
void MR3_set_ri_with_wpoint_pindex_jparallel(int ni_run, double x[]);
void MR3_set_ri_with_wpoint_pindex_virial(int ni_run, double x[], int *atype, double volume[3], int (*cell_diff)[3], int flag_virial);
void MR3_set_ri_with_wpoint_pindex2(int ni_run, double x[], int ni);
void MR3_set_qj_with_wpoint_pindex(int ni_run, double q[]);
void MR3_set_boxsize_with_wpoint_pindex(int wpoint, double boxsize[3]);
void MR3_set_rscale_with_wpoint_pindex(int wpoint, double rscale);
void MR3_set_grscale_with_wpoint_pindex(int wpoint, int nat, double gscale[], double rscale[]);
int MR3_print_fifo2(int flag, int wpoint_last, unsigned long long *writedmabuffer, unsigned long long *readdmabuffer);
void MR3_set_check_read_count(int val);
void MR3_check_read_count(int fd, int wpoint_last, unsigned long long *writedmabuffer, unsigned long long *readdmabuffer);
int MR3_print_fifo2_simple(int flag);
void MR3_get_potentials(int ni, int tblno, double xmax, double *pot, int flag);
void MR3_get_potentials_fixmk(int ni, int tblno, double xmax, double *pot, int flag, int fixmk);
int MR3_get_lastpoint_readbuffer(void);
void MR3_set_lastpoint_readbuffer(int lastpointlocal);
int MR3_num_words_of_readbuffer(int ni, int lastpoint, int flag);
void MR3_start_dma(void);
void mr3_start_dma_(void);
int MR3_find_terminate(unsigned long long *ullp, unsigned int readword_dma);
int MR3_wait_dma(void);
int mr3_wait_dma_(void);
void MR3_write_fpga(int adr, int n, unsigned int *d);
void MR3_write_chip_register(unsigned int chipmask, int adr, int n, unsigned int *d);
void MR3_enable_checksum_mode(int flag);
void MR3_add_checksum(UIUC4 *uiucl, UIUC4 *uiuch, unsigned long long *ullp);
void MR3_recalculate_checksum(void);
int MR3_check_read_checksum(UIUC4 uiucl, UIUC4 uiuch, unsigned long long ull);
void MR3_check_checksum(void);
int MR3_checksum_status(void);
void MR3_disable_checksum_mode(void);
void MR3_clear_checksum_mode(void);
void MR3_set_modeflag(unsigned long long **modeflag, int *nat, int flag);
void MR3_set_fsel(int tblno, int fsel, int nfsel, int flag);
void MR3_reset_fpga_status(void);
void MR3_reset_chip_status(void);
int MR3_print_board_status(int ni, int flag, int force_or_potential);
void MR3_get_fpga_status(void);
void MR3_get_chip_status(void);
int MR3_print_fpga_status_core(int flag, unsigned int *uip, int *is_asic, int *freq_ret);
int MR3_print_fpga_status(int flag);
int MR3_print_chip_status_core(int flag, unsigned int *uip);
int MR3_print_chip_status(int flag);
void MR3_get_board_version(int *version, int *freq);
int MR3_get_fd(void);
char *MR3_get_table_ver_char(void);
void MR3_set_default_table(int tblno);
int MR3_default_device(int board_id);
int mr3_default_device_(int *board_id);
int mr3_default_device__(int *board_id);
void MR3_set_active_num_chips(int nchip);
void MR3init(void);
int MR3init_core(int flag);
void mr3init_(void);
void mr3init__(void);
void MR3init_emu(void);
int MR3_is_MR3init_called(void);
void MR3free(void);
void mr3free_(void);
void mr3free__(void);
void MR3SetTable(char *filename, int tblno, int flag);
void mr3settable_(char *fname_org, int *tblno, int *flag, int n);
void mr3settable__(char *filename, int *tblno, int *flag, int n);
void mr3settable_nf_(char *fname, int *tblno, int *flag, int *n);
void mr3settable_nf__(char *fname, int *tblno, int *flag, int *n);
void MR3SetTable_emu(char *filename, int tblno, int flag);
void mr3settable_emu_nf_(char *fname, int *tblno, int *flag, int *n);
void mr3settable_emu_nf__(char *fname, int *tblno, int *flag, int *n);
void MR3_get_forces(int ni, int tblno, double xmax, double *force, int flag);
void mr3_get_forces_(int *ni, int *tblno, double *xmax, double *force, int *flag);
void mr3_get_forces__(int *ni, int *tblno, double *xmax, double *force, int *flag);
void MR3calcvdw_ij(int ni, double xi[], int atypei[], double force[], int nj, double xj[], int atypej[], int nat, double gscale[], double rscale[], int tblno, double xmax, int periodicflag);
void mr3calcvdw_ij_(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag);
void mr3calcvdw_ij__(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag);
void MR3calcvdw_ij_emu(int ni, double xi[], int atypei[], double force[], int nj, double xj[], int atypej[], int nat, double gscale[], double rscale[], int tblno, double xmax, int periodicflag);
void mr3calcvdw_ij_emu_(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag);
void mr3calcvdw_ij_emu__(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag);
void MR3calcvdw_ij_host(int ni, double xi[], int atypei[], double force[], int nj, double xj[], int atypej[], int nat, double gscale[], double rscale[], int tblno, double xmax, int periodicflag);
void mr3calcvdw_ij_host_(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag);
void mr3calcvdw_ij_host__(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag);
void MR3calcvdw_nlist_host(double x[], int n, int atype[], int nat, double gscale[], double rscale[], int tblno, double xmax, int periodicflag, int numex[], int natex[], double force[]);
void MR3calcvdw(double x[], int n, int atype[], int nat, double gscale[], double rscale[], int tblno, double xmax, int periodicflag, int natchangeflag, double force[]);
void mr3calcvdw_(double x[], int *n, int atype[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag, int *natchangeflag, double force[]);
void mr3calcvdw__(double x[], int *n, int atype[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag, int *natchangeflag, double force[]);
void MR3calccoulomb_ij(int ni, double xi[], double qi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void mr3calccoulomb_ij_(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag);
void mr3calccoulomb_ij__(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag);
void MR3calccoulomb_ij_emu(int ni, double xi[], double qi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void mr3calccoulomb_ij_emu_(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag);
void mr3calccoulomb_ij_emu__(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag);
void MR3calccoulomb_ij_host(int ni, double xi[], double qi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void mr3calccoulomb_ij_host_(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag);
void mr3calccoulomb_ij_host__(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag);
void MR3calccoulomb_nlist_host(double pos[], int n, double q[], double rscale, int tblno, double xmax, int periodicflag, int numex[], int natex[], double force[]);
void MR3calccoulomb(double x[], int n, double q[], double rscale, int tblno, double xmax, int periodicflag, int natchangeflag, double force[]);
void mr3calccoulomb_(double x[], int *n, double q[], double *rscale, int *tblno, double *xmax, int *periodicflag, int *natchangeflag, double force[]);
void mr3calccoulomb__(double x[], int *n, double q[], double *rscale, int *tblno, double *xmax, int *periodicflag, int *natchangeflag, double force[]);
void MR3calccoulomb_ij_exlist(int ni, double xi[], double qi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag, int numex[], int natex[]);
void mr3calccoulomb_ij_exlist_(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag, int numexorg[], int natexorg[]);
void mr3calccoulomb_ij_exlist__(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag, int numexorg[], int natexorg[]);
void MR3calcvdw_ij_exlist(int ni, double xi[], int atypei[], double force[], int nj, double xj[], int atypej[], int nat, double gscale[], double rscale[], int tblno, double xmax, int periodicflag, int numex[], int natex[]);
void mr3calcvdw_ij_exlist_(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag, int numex[], int natex[]);
void mr3calcvdw_ij_exlist__(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag, int numex[], int natex[]);
void MR3calccoulomb_vdw_ij_exlist(int ni, double xi[], double qi[], int atypei[], double force[], int nj, double xj[], double qj[], int atypej[], int nat, double gscalesf[], double gscalesp[], double rscales[], double rscale, int tblno, double xmax, double *potc, double *potv, int periodicflag, int potflag, int changeflag, int numex[], int natex[]);
void mr3calccoulomb_vdw_ij_exlist_(int *ni, double xi[], double qi[], int atypei[], double force[], int *nj, double xj[], double qj[], int atypej[], int *nat, double gscalesf[], double gscalesp[], double rscales[], double *rscale, int *tblno, double *xmax, double *potc, double *potv, int *periodicflag, int *potflag, int *changeflag, int numex[], int natex[]);
void mr3calccoulomb_vdw_ij_exlist__(int *ni, double xi[], double qi[], int atypei[], double force[], int *nj, double xj[], double qj[], int atypej[], int *nat, double gscalesf[], double gscalesp[], double rscales[], double *rscale, int *tblno, double *xmax, double *potc, double *potv, int *periodicflag, int *potflag, int *changeflag, int numex[], int natex[]);
void MR3_make_natex2_from_natex(int n, int natex[], int numex[], int **natex_offset, int **natex2, int **numex2, int **natex2_offset);
void MR3calccoulomb_vdw_ij_exlist_cutoff_host(int ni, double xi[], double qi[], int atypei[], double force[], int nj, double xj[], double qj[], int atypej[], int nat, double gscalesf[], double gscalesp[], double rscales[], double rscale, int tblno, double cutoff, double size[3], double *potc, double *potv, int periodicflag, int potflag, int changeflag, int numex[], int natex[]);
void mr3calccoulomb_vdw_ij_exlist_cutoff_host_(int *ni, double xi[], double qi[], int atypei[], double force[], int *nj, double xj[], double qj[], int atypej[], int *nat, double gscalesf[], double gscalesp[], double rscales[], double *rscale, int *tblno, double *cutoff, double size[3], double *potc, double *potv, int *periodicflag, int *potflag, int *changeflag, int numex[], int natex[]);
void mr3calccoulomb_vdw_ij_exlist_cutoff_host__(int *ni, double xi[], double qi[], int atypei[], double force[], int *nj, double xj[], double qj[], int atypej[], int *nat, double gscalesf[], double gscalesp[], double rscales[], double *rscale, int *tblno, double *cutoff, double size[3], double *potc, double *potv, int *periodicflag, int *potflag, int *changeflag, int numex[], int natex[]);
void MR3calccoulomb_vdw_ij_exlist_host(int ni, double xi[], double qi[], int atypei[], double force[], int nj, double xj[], double qj[], int atypej[], int nat, double gscalesf[], double gscalesp[], double rscales[], double rscale, int tblno, double xmax, double *potc, double *potv, int periodicflag, int potflag, int changeflag, int numex[], int natex[]);
void mr3calccoulomb_vdw_ij_exlist_host_(int *ni, double xi[], double qi[], int atypei[], double force[], int *nj, double xj[], double qj[], int atypej[], int *nat, double gscalesf[], double gscalesp[], double rscales[], double *rscale, int *tblno, double *xmax, double *potc, double *potv, int *periodicflag, int *potflag, int *changeflag, int numex[], int natex[]);
void mr3calccoulomb_vdw_ij_exlist_host__(int *ni, double xi[], double qi[], int atypei[], double force[], int *nj, double xj[], double qj[], int atypej[], int *nat, double gscalesf[], double gscalesp[], double rscales[], double *rscale, int *tblno, double *xmax, double *potc, double *potv, int *periodicflag, int *potflag, int *changeflag, int numex[], int natex[]);
M3_UNIT *m3_allocate_unit(const char *fname, int mode, double xmin, double xmax, int dum);
int m3_allocate_unit_(char *fname_org, int *mode, double *xmin, double *xmax, int *dum, int nchar);
int m3_allocate_unit__(char *fname, int *mode, double *xmin, double *xmax, int *dum, int nchar);
M3_UNIT *m3_allocate_periodic_unit(const char *fname, int mode, double size, int dum);
int m3_allocate_periodic_unit_(char *fname_org, int *mode, double *size, int *dum, int nchar);
int m3_allocate_periodic_unit__(char *fname, int *mode, double *size, int *dum, int nchar);
void m3_free_unit(M3_UNIT *unit);
void m3_free_unit_(int *unit_index);
void m3_free_unit__(int *unit_index);
void m3_set_function_core(M3_UNIT *unit, const char *fname);
void m3_set_function(M3_UNIT *unit, const char *fname);
void m3_set_function_(int *unit_index, char *fname_org, int n);
void m3_set_function__(int *unit_index, char *fname, int n);
void m3_set_positions(M3_UNIT *unit, double (*pos)[3], int n);
void m3_set_positions_(int *unit_index, double (*pos)[3], int *n);
void m3_set_positions__(int *unit_index, double (*pos)[3], int *n);
void m3_set_positions_with_wpoint_pindex(M3_UNIT *unit, double (*pos)[3], int n);
void m3_set_positions_and_types_with_wpoint_pindex(M3_UNIT *unit, double (*pos)[3], int *atype, int n);
void m3_set_charges(M3_UNIT *unit, const double *q, int n);
void m3_set_charges_(int *unit_index, double *q, int *n);
void m3_set_charges__(int *unit_index, double *q, int *n);
void m3_set_rscale(M3_UNIT *unit, double rscale_sq);
void m3_set_rscale_(int *unit_index, double *rscale_sq);
void m3_set_rscale__(int *unit_index, double *rscale_sq);
void m3_set_types(M3_UNIT *unit, const int *atype, int n);
void m3_set_types_(int *unit_index, int *atype, int *n);
void m3_set_types__(int *unit_index, int *atype, int *n);
void m3_set_positions_and_types(M3_UNIT *unit, double (*pos)[3], int *atype, int n);
void m3_set_positions_and_types_(int *unit_index, double (*pos)[3], int *atype, int *n);
void m3_set_positions_and_types__(int *unit_index, double (*pos)[3], int *atype, int *n);
void m3_set_rscale_matrix(M3_UNIT *unit, const double *rscale, int nati, int natj);
void m3_set_rscale_matrix_(int *unit_index, double *rscale, int *nati, int *natj);
void m3_set_rscale_matrix__(int *unit_index, double *rscale, int *nati, int *natj);
void m3_set_charge_matrix(M3_UNIT *unit, const double *gscale, int nati, int natj);
void m3_set_charge_matrix_(int *unit_index, double *gscale, int *nati, int *natj);
void m3_set_charge_matrix__(int *unit_index, double *gscale, int *nati, int *natj);
void m3_set_pipeline_types(M3_UNIT *unit, const int *atype, int n);
void m3_set_pipeline_types_(int *unit_index, int *atype, int *n);
void m3_set_pipeline_types__(int *unit_index, int *atype, int *n);
void m3_set_cells(M3_UNIT *unit, M3_CELL *cell, int ncell);
void m3_set_cells_(int *unit_index, int *base, int *size, int *ncell);
void m3_set_cells__(int *unit_index, int *base, int *size, int *ncell);
void m3_set_softening(M3_UNIT *unit, double e);
void m3_set_softening_(int *unit_index, double *e);
void m3_set_softening__(int *unit_index, double *e);
void m3_set_softenings(M3_UNIT *unit, double *softeningj, int nj);
void m3_set_softenings_(int *unit_index, double *softeningj, int *nj);
void m3_set_softenings__(int *unit_index, double *softeningj, int *nj);
void m3_set_positions_and_softenings(M3_UNIT *unit, double (*pos)[3], double *softeningj, int n);
void m3_set_pipeline_softenings(M3_UNIT *unit, double *softeningi, int ni);
void m3_set_pipeline_softenings_(int *unit_index, double *softeningi, int *ni);
void m3_set_pipeline_softenings__(int *unit_index, double *softeningi, int *ni);
void m3_set_softening_matrix(M3_UNIT *unit, double *softening, int nati, int natj);
void m3_set_softening_matrix_(int *unit_index, double *softening, int *nati, int *natj);
void m3_set_softening_matrix__(int *unit_index, double *softening, int *nati, int *natj);
void m3_set_use_relative_cell_list(int *mode, int flag);
void m3_set_nxbit_nybit_nrcell(int *nxbit, int *nybit, int *nrcell, int flag);
void m3_set_relative_cell_list(M3_UNIT *unit, double boxsize[3], int ldim[3], int nrcell, int (*rcell)[3]);
void m3_clear_forces(M3_UNIT *unit, int ni, double (*force)[3]);
void m3_get_forces(M3_UNIT *unit, int ni, double (*force)[3]);
void m3_calculate_forces(M3_UNIT *unit, double (*xi)[3], int ni, double (*force)[3]);
void m3_calculate_forces_(int *unit_index, double (*xi)[3], int *ni, double (*force)[3]);
void m3_calculate_forces__(int *unit_index, double (*xi)[3], int *ni, double (*force)[3]);
void m3_calculate_potentials(M3_UNIT *unit, double (*xi)[3], int ni, double *eng);
void m3_calculate_potentials_(int *unit_index, double (*xi)[3], int *ni, double *eng);
void m3_calculate_potentials__(int *unit_index, double (*xi)[3], int *ni, double *eng);
void m3_calculate_forces_and_virial(M3_UNIT *unit, double (*xi)[3], int ni, double (*force)[3], double (*xrun_virial)[3], double *fifactor, double fifactor2, double virial[3][3]);
void m3_calculate_forces_8region(M3_UNIT *unit, double (*xi)[3], int ni, int region, double (*force)[3]);
M3_UNIT *m3_get_unit(void);
void m3_set_icellindex(int idx[4], int flag);
void m3_set_icell(M3_UNIT *unit, int icell[3], int region);
void m3_set_box_params(int ldim[3], double boxsize[3], int flag);
void m3_get_jpparams(longlong jpparams[4], int cimode, int run, int idx[4]);
int m3_calc_nread(int virialmode, int region[8]);
void m3_start_force_calculation(M3_UNIT *unit, double (*ri)[3], int n, double (*fi)[3]);
void m3_start_force_calculation_(int *unit_index, double (*ri)[3], int *n, double (*fi)[3]);
void m3_start_force_calculation__(int *unit_index, double (*ri)[3], int *n, double (*fi)[3]);
void m3_start_potential_calculation(M3_UNIT *unit, double (*ri)[3], int n, double *pi);
void m3_start_potential_calculation_(int *unit_index, double (*ri)[3], int *n, double *pi);
void m3_start_potential_calculation__(int *unit_index, double (*ri)[3], int *n, double *pi);
void m3_wait_calculation(M3_UNIT *unit);
void m3_wait_calculation_(int *unit_index);
void m3_wait_calculation__(int *unit_index);
void m3_setup_overlap(M3_UNIT *unit);
void m3_setup_overlap_(int *unit_index);
void m3_setup_overlap__(int *unit_index);
void m3_start_overlap_calculation(M3_UNIT *unit);
void m3_start_overlap_calculation_(int *unit_index);
void m3_start_overlap_calculation__(int *unit_index);
void m3_wait_overlap_calculation(M3_UNIT *unit);
void m3_wait_overlap_calculation_(int *unit_index);
void m3_wait_overlap_calculation__(int *unit_index);
void m3_print_unit(M3_UNIT *unit);
void m3_print_unit_(int *unit);
void m3_print_unit__(int *unit);
void m3_start_dmarecord(M3_UNIT *unit, int ni);
void m3_stop_dmarecord(M3_UNIT *unit);
void m3_set_positions_and_types_from_dmarecord(M3_UNIT *unit, double (*pos)[3], int *atype, int n);
void m3_set_pipeline_positions_from_dmarecord(M3_UNIT *unit, double (*xi)[3], int ni);
void MR3calccoulomb_ij_m3(int ni, double xi[], double qi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void mr3calccoulomb_ij_m3_(int *ni, double xi[], double qi[], double force[], int *nj, double xj[], double qj[], double *rscale, int *tblno, double *xmax, int *periodicflag);
void MR3calcvdw_ij_m3(int ni, double xi[], int atypei[], double force[], int nj, double xj[], int atypej[], int nat, double gscale[], double rscale[], int tblno, double xmax, int periodicflag);
void mr3calcvdw_ij_m3_(int *ni, double xi[], int atypei[], double force[], int *nj, double xj[], int atypej[], int *nat, double gscale[], double rscale[], int *tblno, double *xmax, int *periodicflag);
void MR3_report_chip_status(void);
void MR3_get_temperature(int temp[2][13]);
int MR3_check_temperature(int flag, int freq_in, int period_in);
void MR3print_chip_temperature(int flag);
void MR3_ki_pack(int n, int (*k0)[3], int (*k1)[3], longlong (*x)[3]);
void MR3_ki_pack_multi_k(int n, int (*k)[3], longlong (*rk));
void MR3_ki_pack_multi_k_fixmk(int n, int (*k)[3], longlong (*rk));
void MR3_ki_pack_multi_x(int n, double (*x)[3], longlong (*rk));
void MR3_ki_pack_multi_x_fixmk(int n, double (*x)[3], longlong (*rk));
void MR3_rscale_and_pack_ki(int n, void *kx, int kxtype, longlong *kipacked);
void MR3_rscale_and_pack_ki_fixmk(int n, void *kx, int kxtype, longlong *kipacked);
void MR3_ri_clear_and_pack_ki_atype(int n, int *atype, longlong (*ri)[2]);
void MR3_rscale_and_pack32_x(int n, double (*x)[3], longlong (*rj)[2]);
void MR3_rscale_and_pack32_x_atype(int n, double (*x)[3], int atype[], longlong (*rj)[2]);
void MR3_rscale_and_pack32_x_phi(int n, double (*x)[3], double phi[], longlong (*rj)[2], double cphi, int minus);
void MR3_rscale_and_pack32_x_cphi(int n, double (*x)[3], longlong (*rj)[2], double cphi);
void MR3_rscale_and_pack32_k(int n, int (*k)[3], longlong (*rj)[2]);
void MR3_rscale_and_pack32_k_atype(int n, int (*k)[3], int atype[], longlong (*rj)[2]);
void MR3_rscale_and_pack32_k_phi(int n, int (*k)[3], double phi[], longlong (*rj)[2], double cphi, int minus);
void MR3_rscale_and_pack32_k_cphi(int n, int (*k)[3], longlong (*rj)[2], double cphi);
void MR3_rscale_and_pack32_fixmk_x(int n, double (*x)[3], longlong (*rj)[2]);
void MR3_rscale_and_pack32_fixmk_x_atype(int n, double (*x)[3], int atype[], longlong (*rj)[2]);
void MR3_rscale_and_pack32_fixmk_x_phi(int n, double (*x)[3], double phi[], longlong (*rj)[2], double cphi, int minus);
void MR3_rscale_and_pack32_fixmk_x_cphi(int n, double (*x)[3], longlong (*rj)[2], double cphi);
void MR3_rscale_and_pack32_fixmk_k(int n, int (*k)[3], longlong (*rj)[2]);
void MR3_rscale_and_pack32_fixmk_k_atype(int n, int (*k)[3], int atype[], longlong (*rj)[2]);
void MR3_rscale_and_pack32_fixmk_k_phi(int n, int (*k)[3], double phi[], longlong (*rj)[2], double cphi, int minus);
void MR3_rscale_and_pack32_fixmk_k_cphi(int n, int (*k)[3], longlong (*rj)[2], double cphi);
void MR3calcewald_ij(int ni, int ki[], uint phi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void MR3calcwine32_ij(int ni, int ki[], uint phi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag, double cphi);
void MR3calcdft32_ij(int ni, int ki[], uint phi[], double *kc, double *ks, int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void MR3calcdft32_ij_dphij(int ni, int ki[], uint phi[], double *kc, double *ks, int nj, double xj[], double qj[], double phij[], double rscale, int tblno, double xmax, int periodicflag);
void MR3calcdft32_ij_f(int ni, int ki[], uint phi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void MR3_set_Simulatorflag(int flag);
void MR3calcewald_ij_emu(int ni, int ki[], uint phi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void MR3calcwine32_ij_emu(int ni, int ki[], uint phi[], double force[], int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag, double cphi);
void MR3calcdft32_ij_emu(int ni, int ki[], uint phi[], double *kc, double *ks, int nj, double xj[], double qj[], double rscale, int tblno, double xmax, int periodicflag);
void MR3calcdft32_ij_dphij_emu(int ni, int ki[], uint phi[], double *kc, double *ks, int nj, double xj[], double qj[], double phij[], double rscale, int tblno, double xmax, int periodicflag);
void MR3_get_forces_dmaed(int ni, int tblno, double xmax, double *force, int flag, int l);
void MR3_calc_DFT_with_kvec_host(double x[], double q[], double cellsize[], int n, int knum, int k[], double *bs, double *bc);
void MR3_calc_IDFT_withoutexp_host(double x[], double cellsize[], int n, int knum, int k[], double *bs, double *bc, double factor, double pot[]);
void MR3_calc_DFT_IDFT_withoutexp_host(double x[], double q[], double cellsize[], int n, int knum, int k[], double factor, double pot[]);
void mr3_calc_dft_idft_withoutexp_host_(double x[], double q[], double cellsize[], int *n, int *knum, int k[], double *factor, double pot[]);
void mr3_calc_dft_idft_withoutexp_host__(double x[], double q[], double cellsize[], int *n, int *knum, int k[], double *factor, double pot[]);
void kcs2ap(double *kamp, double *kphase, int knum, double *kc, double *ks);
void set_rj_40_int24(int n, int k[][3], uint *phi);
void set_rj_dphi_c(int n, void *xk, double *dphi, int minus, double cphi, int fixmk, int xktype);
void set_rj_fixmk(int n, void *xk, void *qh, int minus, double cphi, int fixmk, 
int xktype, int qhtype);
void MR3calcdxt_ij_dphij_atype(int nx, double x[], int atypex[], double *r, int nk, int k[], int atypek[], double qj[], double phij[], int nat, double gscale[], double rscale[], int tblno, double xmax, double cphi, int set_j_40, int fixmk, int inv, int func, int force, int setj, int setq, int setgrscale);
void MR3calcdxt_ij_dphij(int nx, double x[], int atypex[], double *r, int nk, int k[], double qj[], double phij[], int tblno, double xmax, double cphi, int set_j_40, int fixmk, int inv, int func, int force, int setj, int setq);
void MR3calcdft_real_to_complex(int ni, int ki[], uint phi[], double *kc, double *ks, int nj, double xj[], double qj[], int tblno, double xmax);
void MR3calcdft_real_atype_to_complex(int ni, int ki[], uint atypek[], double *kc, double *ks, int nj, double xj[], uint atypex[], int nat, double gscale[], double rscale[], int tblno, double xmax);
void MR3calcdft_real_to_complex(int ni, int ki[], uint phi[], double *kc, double *ks, int nj, double xj[], double qj[], int tblno, double xmax);
void MR3calcidft_complex_to_real(int ni, double xi[], uint phi[], double *z_r, int nj, int kj[], double *kc, double *ks, int tblno, double xmax);
void MR3calcidstII_dphij_to_real(int ni, double xi[], uint phi[], double *z_r, int nj, int kj[], double *kamp, double *kphase, int tblno, double xmax);
void MR3calcidftII_complex_to_real_fikmk(int ni, double xi[], uint phi[], double *z_r, int nj, int kj[], double *kc, double *ks, int tblno, double xmax);
void MR3calcidftII_complex_to_real_plusk(int ni, double xi[], uint phi[], double *z_r, int nj, int kj[], double *kc, double *ks, int tblno, double xmax);
void MR3calcewald_dft_host(int k[], int knum, double x[], int n, double chg[], double cellsize[3], double bs[], double bc[]);
void MR3calcewald_idft_eng_host(int k[], double bs[], double bc[], int knum, double x[], int n, double cellsize[3], double force[]);
void MR3calcewald_idft_force_host(int k[], double bs[], double bc[], int knum, double x[], int n, double cellsize[3], double force[]);
void MR3calcewald_idft_force_float_host(int k[], double bs[], double bc[], int knum, double x[], int n, double cellsize[3], double force[]);
void MR3calcewald_host(int *k, int knum_org, double *x, int n, double *chg, double alpha, double epsilon, double cell[3][3], double *force, double *tpot, double stress[3][3]);
void xscale_cellsize(double *sx, double *x, int n, double cellsize[3]);
void MR3calcewald(int *k, int knum_org, double *x, int n, double *chg, double alpha, double epsilon, double cell[3][3], double *force, double *tpot, double stress[3][3]);
void mr3calcewald_host__(int *k, int *knum, double *x, int *n, double *chg, double *alpha, double *epsilon, double cell[3][3], double *force, double *tpot, double stress[3][3]);
void mr3calcewald_host_(int *k, int *knum, double *x, int *n, double *chg, double *alpha, double *epsilon, double cell[3][3], double *force, double *tpot, double stress[3][3]);
void mr3calcewald_(int *k, int *knum, double *x, int *n, double *chg, double *alpha, double *epsilon, double cell[3][3], double *force, double *tpot, double stress[3][3]);

/* exlist.c */
void MR3_setup_exlist(int n, int *bckptr);
void mr3_setup_exlist_(int *n, int *bckptr);
void MR3_setup_exlist2(int n, int **numex, int **natex, int flag);
void mr3_setup_exlist2_(int *n, int *numex, int *natex, int *flag);
void MR3_convert_exlist(int n, int numex[], int natex[], int flag, int **new2org, int ***nexlist, int ***jexlist, int ***flagexlist);
void MR3_register_exlist(int n, int numex[], int natex[], int *convert_index, int flag, int *exlist_index);
void mr3_register_exlist_(int *n, int numex[], int natex[], int *convert_index, int *flag, int *exlist_index);
void MR3_pack_exlist(int exlist_index, int ni_start, int ni_len, int *cell2pdb, int *pdb2cell, int **run2cell, int (**nexlist)[12], int (**jexlist)[12], int (**flagexlist)[12][40], int flag);
void MR3_make_modeflag(int ni_run, int run2cell[], int cell2pdb[], int skipflag[], unsigned long long modeflag[]);
void MR3_pack_exlist2(int exlist_index, int ni_start, int ni_len, int *cell2pdb, int *pdb2cell, int **run2cell, int *ni_run, int (**nexlist)[12], int (**jexlist)[12], int (**flagexlist)[12][40], int flag);
void MR3_pack_exlist3(int exlist_index, int ni_start, int ni_len, int *cell2pdb, int *pdb2cell, int **run2cell, int *ni_run, int (**nexlist)[12], int (**jexlist)[12], int (**flagexlist)[12][40], int flag);
void MR3_set_exlist_local(int (**nexlist)[12], int (**jexlist)[12], int (**flagexlist)[12][40], int flag);
void MR3_set_exlist(int exlist_index, int ni_start, int ni_len, int *cell2pdb, int *pdb2cell, int **run2cell, int *ni_run, int flag);
void MR3_disp_nlist(int n, int numex[], int natex[], int flag);
void mr3_disp_nlist_(int *n, int numex[], int natex[], int *flag);
void MR3_remove_non_interaction_particle(int *exlist_index, int n, double charges[], int atype[], int nat, double gscales[], int *convert_index, int flag, int flag_noskip);
int MR3_check_ni_run_max(int ni_run, int ni_run_max);
void MR3_make_run2cell_for_protein(int ni_start, int ni_len, int *skipflag, int *pdb2mol, int *pdb2cell, int *cell2pdb, int ni_run_max, int *run2cell, int *ni_run, int flag);
void MR3_make_exlist_in_pdb(int exlist_index, int ni_run, int *run2cell, int *cell2pdb, int *pdb2cell);
void MR3_set_exlist_from_pdb_exlist(int exlist_index, int *run2cell, int *pdb2cell, int *cell2pdb, int *pdb2image, int *cell2image, int *ni_run);
void MR3_check_exlist(int ni_run, char *comment);
void MR3_print_exlist(int ni_run, char comment[]);

/* virial.c */
void M3calccoulomb_vir_new(int nmlcl, double pos[][3], double charge[], double alpha, int notabl, double volume[3], int ldimx, int ldimy, int ldimz, double rcut_v, double force[][3], double virial2[3][3], int nf_per, int nf_vir);
void M3calccoulomb_vir_old(int nmlcl, double pos[][3], double charge[], double alpha, int notabl, double volume[3], int ldimx, int ldimy, int ldimz, double rcut_v, double force[][3], double virial2[3][3], int nf_per, int nf_vir);
void M3calccoulomb_vir(int nmlcl, double pos[][3], double charge[], double alpha, int notabl, double volume[3], int ldimx, int ldimy, int ldimz, double rcut_v, double force[][3], double virial2[3][3], int nf_per, int nf_vir);
void m3calccoulomb_vir_c_(int *nmlcl, double pos[][3], double charge[], double *alpha, int *notabl, double volume[3], int *ldimx, int *ldimy, int *ldimz, double *rcut_v, double force[][3], double virial2[3][3], int *nf_per, int *nf_vir);
void M3calcvdw_vir_new(int nmlcl, double pos[][3], int natype[], int natot, double gscale[], double rscale[], int notabl, double volume[], int ldimx, int ldimy, int ldimz, double rcut_v, double force[][3], double virial2[3][3], int nf_per, int nf_vir);
void M3calcvdw_vir_old(int nmlcl, double pos[][3], int natype[], int natot, double gscale[], double rscale[], int notabl, double volume[], int ldimx, int ldimy, int ldimz, double rcut_v, double force[][3], double virial2[3][3], int nf_per, int nf_vir);
void M3calcvdw_vir(int nmlcl, double pos[][3], int natype[], int natot, double gscale[], double rscale[], int notabl, double volume[], int ldimx, int ldimy, int ldimz, double rcut_v, double force[][3], double virial2[3][3], int nf_per, int nf_vir);
void m3calcvdw_vir_c_(int *nmlcl, double pos[][3], int natype[], int *natot, double gscale[], double rscale[], int *notabl, double volume[], int *ldimx, int *ldimy, int *ldimz, double *rcut_v, double force[][3], double virial2[3][3], int *nf_per, int *nf_vir);

/* cellindex.c */
void MR3_enable_wpoint_pindex(void);
void MR3_disable_wpoint_pindex(void);
int MR3_is_wpoint_pindex_enabled(void);
void MR3_use_wpoint_pindex(void);
void MR3_not_use_wpoint_pindex(void);
int MR3_is_use_wpoint_pindex(void);
void MR3_free_wpoint_pindex(int count);
void MR3_reallocate_wpoint_pindex(int nmalloc);
int MR3_get_wpoint_pindex_count(void);
void MR3_set_wpoint_pindex_count(int wpoint_pindex_count);
void MR3_set_wpoint_to_wpoint_pindex(int count, int wpoint);
void MR3_initialize_wpoint_pindex(int nj, int interleave);
void MR3_copy_wpoint_pindex(int count, int nj, int jimage, double op[3], int atype, int flag);
void MR3_set_coulomb_vdw_factor(double cgf);
void mr3_set_coulomb_vdw_factor_(double *cgf);
void mr3_set_coulomb_vdw_factor__(double *cgf);
void MR3_print_run2cell_cell2image_cell2pdb_skipflag(int ni_start, int ni_len, int *run2cell, int *cell2image, int *cell2pdb, int *skipflag, int *pdb2mol);
void MR3_get_forces_overlap(double force[]);
void mr3_get_forces_overlap_(double force[]);
void MR3_get_forces_and_virial_overlap(double force[], double virial[3][3]);
void mr3_get_forces_and_virial_overlap_(double force[], double virial[3][3]);
void MR3calccoulomb_ci(int n, double x[], double q[], double force[], double rscale, int tblno, double rcut, double skinnb, double volume[3], int ldim[3]);
void mr3calccoulomb_ci_(int *n, double x[], double q[], double force[], double *rscale, int *tblno, double *rcut, double *skinnb, double volume[3], int ldim[3]);
void MR3calccoulomb_ci_vir(int n, double x[], double q[], double force[], double rscale, int tblno, double rcut, double skinnb, double volume[3], int ldim[3], int vir_flag, double virial[3][3]);
void mr3calccoulomb_ci_vir_(int *n, double x[], double q[], double force[], double *rscale, int *tblno, double *rcut, double *skinnb, double volume[3], int ldim[3], int *vir_flag, double virial[3][3]);
void MR3calcvdw_ci(int n, double x[], int atype[], int nat, double force[], double gscales[], double rscales[], int tblno, double rcut, double skinnb, double volume[3], int ldim[3]);
void mr3calcvdw_ci_(int *n, double x[], int atype[], int *nat, double force[], double gscales[], double rscales[], int *tblno, double *rcut, double *skinnb, double volume[3], int ldim[3]);
void MR3calcvdw_ci_vir(int n, double x[], int atype[], int nat, double force[], double gscales[], double rscales[], int tblno, double rcut, double skinnb, double volume[3], int ldim[3], int vir_flag, double virial[3][3]);
void mr3calcvdw_ci_vir_(int *n, double x[], int atype[], int *nat, double force[], double gscales[], double rscales[], int *tblno, double *rcut, double *skinnb, double volume[3], int ldim[3], int *vir_flag, double virial[3][3]);
void MR3calccoulomb_vdw_ci(int n, double x[], double q[], int atype[], int nat, double force[], double rscale, double gscalesf[], double gscalesp[], double rscales[], int tblno, double rcut, double skinnb, double volume[3], int ldim[3], double *potc, double *potv, int *convert_index, int potflag, int flag);
void mr3calccoulomb_vdw_ci_(int *n, double x[], double q[], int atype[], int *nat, double force[], double *rscale, double gscalesf[], double gscalesp[], double rscales[], int *tblno, double *rcut, double *skinnb, double volume[3], int ldim[3], double *potc, double *potv, int *convert_index, int *potflag, int *flag);
void MR3calccoulomb_ci_exlist(int n, double x[], double q[], double force[], double rscale, int tblno, int numex[], int natex[], double rcut, double skinnb, double volume[3], int ldim[3], int *convert_index, int flag);
void mr3calccoulomb_ci_exlist_(int *n, double x[], double q[], double force[], double *rscale, int *tblno, int numex[], int natex[], double *rcut, double *skinnb, double volume[3], int ldim[3], int *convert_index, int *flag);
void MR3calcvdw_ci_exlist(int n, double x[], int atype[], int nat, double force[], double gscales[], double rscales[], int tblno, int numex[], int natex[], double rcut, double skinnb, double volume[3], int ldim[3], int *convert_index, int flag);
void mr3calcvdw_ci_exlist_(int *n, double x[], int atype[], int *nat, double force[], double gscales[], double rscales[], int *tblno, int numex[], int natex[], double *rcut, double *skinnb, double volume[3], int ldim[3], int *convert_index, int *flag);
void MR3calccoulomb_vdw_ci_exlist(int n, double x[], double q[], int atype[], int nat, double force[], double rscale, double gscalesf[], double gscalesp[], double rscales[], int tblno, int numex[], int natex[], double rcut, double skinnb, double volume[3], int ldim[3], double *potc, double *potv, int *convert_index, int potflag, int flag);
void mr3calccoulomb_vdw_ci_exlist_(int *n, double x[], double q[], int atype[], int *nat, double force[], double *rscale, double gscalesf[], double gscalesp[], double rscales[], int *tblno, int *numex, int natex[], double *rcut, double *skinnb, double volume[3], int ldim[3], double *potc, double *potv, int *convert_index, int *potflag, int *flag);
void MR3calccoulomb_vdw_exlist(int n, double x[], double q[], int atype[], int nat, double force[], double rscale, double gscalesf[], double gscalesp[], double rscales[], int tblno, int numex[], int natex[], double volume1, double *potc, double *potv, int *convert_index, int potflag, int flag);
void mr3calccoulomb_vdw_exlist_(int *n, double x[], double q[], int atype[], int *nat, double force[], double *rscale, double gscalesf[], double gscalesp[], double rscales[], int *tblno, int numex[], int natex[], double *volume1, double *potc, double *potv, int *convert_index, int *potflag, int *flag);
void MR3_set_rclist_pointers(int **start_rclist, int **size_rclist, int flag);
void MR3_set_icell_pointers(int **icell_size, int (**icell_index)[4], int flag);
void MR3_make_run2cell_for_water(int *pdb2mol, int *mainatom, int *pdb2cell, int *cell2pdb, int ni_run_max, int *run2cell, int *ni_run, int flag);

/* misc.c */
void MR3_print_calc_speed(int ni, int nj, double njfactor, int loop, double time);
void *MR3_my_malloc(size_t n);
void *MR3_my_malloc2(size_t n, char *s);
void MR3_my_free(void *p);
void MR3_my_free2(void **p, char *s);
void MR3_get_cputime(double *laptime, double *sprittime);
void MR3_get_process_size(char *message, char *program_name);
void mr3_get_process_size_(char *message_org, char *program_name_org, int m, int n);
void mr3_get_process_size__(char *message_org, char *program_name_org, int m, int n);
void MR3_sort_with_index_int(int data[], int index[], int left, int right);
void MR3_exit(int flag);

/* sock_lib.c */
int MR3_close_ch(int s_sock);
int mr3_close_ch_(int *s_sock);
int MR3_open_port(int port_number);
int MR3_sock_read(int sockfd, char *buf, size_t count);
int mr3_sock_read_(int *sockfd, char *buf, int *count);
int mr3_sock_read__(int *sockfd, char *buf, int *count);
int mr3_sock_read_i_(int *sockfd, int *buf);
int mr3_sock_read_i__(int *sockfd, int *buf);
int MR3_sock_read_iv(int sockfd, int *buf, int count);
int mr3_sock_read_iv_(int *sockfd, int *buf, int *count);
int mr3_sock_read_iv__(int *sockfd, int *buf, int *count);
int MR3_sock_read_d(int sockfd, double *buf);
int mr3_sock_read_d__(int *sockfd, double *buf);
int mr3_sock_read_d_(int *sockfd, double *buf);
int MR3_sock_read_dv(int sockfd, double *buf, int count);
int mr3_sock_read_dv__(int *sockfd, double *buf, int *count);
int mr3_sock_read_dv_(int *sockfd, double *buf, int *count);
int MR3_sock_write(int sockfd, char *buf, size_t count);
int MR3_sock_write_c(int sockfd, char *buf);
int mr3_sock_write_c_(int *sockfd, char *buf);
int mr3_sock_write_c__(int *sockfd, char *buf);
int MR3_sock_write_i(int sockfd, int buf);
int mr3_sock_write_i_(int *sockfd, int *buf);
int mr3_sock_write_i__(int *sockfd, int *buf);
int MR3_sock_write_iv(int sockfd, int *buf, int count);
int mr3_sock_write_iv_(int *sockfd, int *buf, int *count);
int mr3_sock_write_iv__(int *sockfd, int *buf, int *count);
int MR3_sock_write_dv(int sockfd, double *buf, int count);
int mr3_sock_write_dv__(int *sockfd, double *buf, int *count);
int mr3_sock_write_dv_(int *sockfd, double *buf, int *count);
int MR3_sock_gets(int sockfd, char *str, size_t count);
int MR3_sock_puts(int sockfd, char *str);
void MR3_sock_init(int *s_sock_org, int port_num, double x[], int igraph[], int natom, int str_len, int lbres[], int ipres[], int nres);
void mr3_sock_init_(int *s_sock, int *port_num, double x[], int igraph[], int *natom, int *str_len, int lbres[], int ipres[], int *nres);
void mr3_sock_init__(int *s_sock, int *port_num, double x[], int igraph[], int *natom, int *str_len, int lbres[], int ipres[], int *nres);
void MR3_sock_1step(int s_sock, double t1, double time, double t2, int recv_buf[], int natom, double x[], double f[], double f_temp[]);
void mr3_sock_1step_(int *s_sock, double *t1, double *time, double *t2, int recv_buf[], int *natom, double x[], double f[], double f_tmp[]);
void mr3_sock_1step__(int *s_sock, double *t1, double *time, double *t2, int recv_buf[], int *natom, double x[], double f[], double f_tmp[]);

