#define M2_NUM_RACO_WORDS 1024
#define M2_NUM_RAEX_WORDS 256

#ifndef TRUE
#define TRUE 1
#endif /* TRUE */
#ifndef FALSE
#define FALSE 0
#endif /* FALSE */

#define sq(x) ((x) * (x))

/* definitions for an MDGRAPE-2 pipeline */
#define MDGP2_WID_TBL_0       27
#define MDGP2_WID_TBL_1       24
#define MDGP2_WID_TBL_2       20
#define MDGP2_WID_TBL_3       16
#define MDGP2_WID_TBL_4       11
#define MDGP2_WID_TBL_EOFFSET  6
#define MDGP2_WID_TBL_EXP      8
#define MDGP2_WID_TBL_DX      20
#define MDGP2_WID_R           40

#define BIT(n,b) (( (n)>>(b) )&1)
#define MASK(n) ((0x1<<(n)) -1)
#define LMASK(n) (((unsigned long long)0x1<<(n)) -1)
#define SLICE(n,pos,width) (( (n)>>(pos) )& MASK(width) )
#define LSLICE(n,pos,width) (( (n)>>(pos) )& LMASK(width) )

typedef union { float f; unsigned int i; } FLOAT;
typedef union { double f; long long i; } SDOUBLE;

typedef struct {
  int estart;
  int mshift;
  double domain_max;
  double c[M2_NUM_RACO_WORDS][6];
  int ci[M2_NUM_RACO_WORDS][6];
  int e[M2_NUM_RAEX_WORDS];
  double ed[M2_NUM_RAEX_WORDS];
} mr1tablecoefficients;
