#define NMAX      65536
#define KMAX      16384
//#define NMAX      8192
#define NTHRE      128
#define NLOAD       32
//#define NLOAD      128
#define ATYPE            64
#define ATYPE2         (ATYPE * ATYPE)
#define ATYPE_NACL        2
#define ATYPE_NACL2    (ATYPE_NACL * ATYPE_NACL)

#define MD_REAL_R2MIN 0.0001f
#define MD_REAL_R2MAX 10.0f
#define MD_LJ_R2MIN   0.25
#define MD_LJ_R2MAX   64.0

typedef union {
  float q;
  int atype;
} VG_QATYPE;

typedef struct {
  int r[3];
  VG_QATYPE qatype;
} VG_XVEC;

typedef struct {
  float k[3];
  float factor1;
} VG_KVEC;

typedef struct {
  float gscale;
  float rscale;
} VG_MATRIX;

typedef struct {
  float pol;
  float sigm;
  float ipotro;
  float pc;
  float pd;
  float zz;
} VG_MATRIX_NACL;

typedef union {
  int i;
  float f;
} FI;

typedef union {
  struct{
    FI fi0;
    FI fi1;
  } fi2;
  double d;
} DI2;

#ifdef MR3_MALLOC
#define MR3_malloc_pointer(x,y) MR3_my_malloc2(x,y)
#define MR3_free_pointer(x,y)   MR3_my_free2((void **)(&(x)),y)
#else
#define MR3_malloc_pointer(x,y) malloc(x)
#define MR3_free_pointer(x,y)   free(x)
#endif

#define MR3_exit(x) exit(x)




