#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "mr3_core.h"


void mr3init_(void)
{
  MR3init();
}


void mr3init__(void)
{
  mr3init_();
}


void mr3free_(void)
{
  MR3free();
}


void mr3free__(void)
{
  mr3free_();
}


void mr3settable_(char *fname_org, int *tblno, int *flag, int n)
{
  char fname[1000];

  while(fname_org[n-1]==' '){
    //    printf("fname_org[%d]=%c\n",n-1,fname_org[n-1]);
    n--;
  }
  strncpy(fname,fname_org,n);
  *(fname+n)='\0';
  MR3SetTable(fname,*tblno,*flag);
}


void mr3settable__(char *filename, int *tblno, int *flag, int n)
{
  mr3settable_(filename,tblno,flag,n);
}


void mr3settable_nf_(char *fname, int *tblno, int *flag, int *n)
{
    char *f;

    if((f=(char *)MR3_malloc_pointer(sizeof(char)*(*n+1),"f in mr3settable_nf_"))==NULL){
	fprintf(stderr,"** error : can't malloc f **\n");
	MR3_exit(1);
    }
    strncpy(f,fname,*n); *(f+*n)='\0';
    MR3SetTable(f,*tblno,*flag);
    MR3_free_pointer(f,"f in mr3settable_nf_");
}


void mr3settable_nf__(char *fname, int *tblno, int *flag, int *n)
{
  mr3settable_nf_(fname,tblno,flag,n);
}


void mr3calccoulomb_ij_(int *ni, double xi[], double qi[], double force[],
			int *nj, double xj[], double qj[],
			double *rscale, 
			int *tblno, double *xmax, int *periodicflag)
{
  MR3calccoulomb_ij(*ni,xi,qi,force,
		    *nj,xj,qj,
		    *rscale, 
		    *tblno,*xmax,*periodicflag);
}


void mr3calccoulomb_ij__(int *ni, double xi[], double qi[], double force[],
			 int *nj, double xj[], double qj[],
			 double *rscale, 
			 int *tblno, double *xmax, int *periodicflag)
{
  mr3calccoulomb_ij_(ni,xi,qi,force,
		     nj,xj,qj,
		     rscale, 
		     tblno,xmax,periodicflag);
}


void mr3calccoulomb_(double x[], int *n, double q[], double *rscale,
		     int *tblno, double *xmax, int *periodicflag,
		     int *natchangeflag, double force[])
{
  MR3calccoulomb(x,*n,q,*rscale,*tblno,*xmax,*periodicflag,
		 *natchangeflag,force);
}


void mr3calccoulomb__(double x[], int *n, double q[], double *rscale,
		      int *tblno, double *xmax, int *periodicflag,
		      int *natchangeflag, double force[])
{
  mr3calccoulomb_(x,n,q,rscale,
		  tblno,xmax,periodicflag,
		  natchangeflag,force);
}


void mr3calcvdw_ij_(int *ni, double xi[], int atypei[], double force[],
		    int *nj, double xj[], int atypej[],
		    int *nat, double gscale[], double rscale[],
		    int *tblno, double *xmax, int *periodicflag)
{
    int *atypei2,*atypej2;
    int i;

    if((atypei2=(int *)MR3_malloc_pointer(sizeof(int)*(*ni),"atypei2 in mr3calcvdw_ij_"))==NULL){
        fprintf(stderr,
                "** error at malloc atypei2 in mr3calcvdw_ij_ **\n");
        MR3_exit(1);
    }
    if((atypej2=(int *)MR3_malloc_pointer(sizeof(int)*(*nj),"atypej2 in mr3calcvdw_ij_"))==NULL){
        fprintf(stderr,
                "** error at malloc atypej2 in mr3calcvdw_ij_ **\n");
        MR3_exit(1);
    }
#if 1
    for(i=0;i<*ni;i++){
      if(atypei[i]>0){
	atypei2[i]=atypei[i]-1;
      }
      else{
	printf("  warning : atypei[%d]=%d should be positive\n",
	       i,atypei[i]);
	atypei2[i]=0;
      }
    }
    for(i=0;i<*nj;i++){
      if(atypej[i]>0){
	atypej2[i]=atypej[i]-1;
      }
      else{
	printf("  warning : atypej[%d]=%d should be positive\n",
	       i,atypej[i]);
      }
    }
#else
    for(i=0;i<*ni;i++) atypei2[i]=atypei[i]-1;
    for(i=0;i<*nj;i++) atypej2[i]=atypej[i]-1;
#endif
    
    MR3calcvdw_ij(*ni,xi,atypei2,force,
		  *nj,xj,atypej2,
		  *nat,gscale,rscale,
		  *tblno,*xmax,*periodicflag);
    MR3_free_pointer(atypei2,"atypei2 in mr3calcvdw_ij_");
    MR3_free_pointer(atypej2,"atypej2 in mr3calcvdw_ij_");
}


void mr3calcvdw_(double x[], int *n, int atype[], int *nat,
		 double gscale[], double rscale[],
		 int *tblno, double *xmax, int *periodicflag,
		 int *natchangeflag, double force[])
{
  int *atype2;
  int i;

  if((atype2=(int *)malloc(sizeof(int)*(*n)))==NULL){
    fprintf(stderr,
	    "** error at malloc atype2 in mr3calcvdw_ **\n");
    exit(1);
  }
  for(i=0;i<*n;i++){
    if(atype[i]>0){
      atype2[i]=atype[i]-1;
    }
    else{
      printf("  warning : atype[%d]=%d should be positive\n",
	     i,atype[i]);
      atype2[i]=0;
    }
  }
  MR3calcvdw(x,*n,atype2,*nat,
	     gscale,rscale,
	     *tblno,*xmax,*periodicflag,
	     *natchangeflag,force);
  free(atype2);
}


void mr3calcvdw_ij__(int *ni, double xi[], int atypei[], double force[],
		     int *nj, double xj[], int atypej[],
		     int *nat, double gscale[], double rscale[],
		     int *tblno, double *xmax, int *periodicflag)
{
  mr3calcvdw_ij_(ni,xi,atypei,force,
		 nj,xj,atypej,
		 nat,gscale,rscale,
		 tblno,xmax,periodicflag);
}


void mr3calcvdw__(double x[], int *n, int atype[], int *nat,
		  double gscale[], double rscale[],
		  int *tblno, double *xmax, int *periodicflag,
		  int *natchangeflag, double force[])
{
  mr3calcvdw_(x,n,atype,nat,
	      gscale,rscale,
	      tblno,xmax,periodicflag,
	      natchangeflag,force);
}


void mr3calcewald_(int *k, int *knum, double *x, int *n,
		   double *chg, double *alpha, double *epsilon,
		   double cell[3][3], double *force,
		   double *tpot, double stress[3][3])
{
    MR3calcewald(k,*knum,x,*n,chg,*alpha,*epsilon,cell,
		 force,tpot,stress);
}


void mr3calcewald__(int *k, int *knum, double *x, int *n,
		    double *chg, double *alpha, double *epsilon,
		    double cell[3][3], double *force,
		    double *tpot, double stress[3][3])
{
    mr3calcewald_(k,knum,x,n,chg,alpha,epsilon,cell,
		  force,tpot,stress);
}


void mr3calcewald_host_(k,knum,x,n,chg,alpha,epsilon,cell,
			force,tpot,stress)
int *n,*k,*knum;
double *x,*chg,cell[3][3],*force,*tpot,*alpha,*epsilon,stress[3][3];
{
    MR3calcewald_host(k,*knum,x,*n,chg,*alpha,*epsilon,cell,
                      force,tpot,stress);
}


void mr3calcewald_host__(k,knum,x,n,chg,alpha,epsilon,cell,
                         force,tpot,stress)
int *n,*k,*knum;
double *x,*chg,cell[3][3],*force,*tpot,*alpha,*epsilon,stress[3][3];
{
    MR3calcewald_host(k,*knum,x,*n,chg,*alpha,*epsilon,cell,
                      force,tpot,stress);
}



